﻿define config.default_text_cps = 45

image bg_classroom = im.Scale("classroom.png", 1920, 1080)
image bg_cafet = im.Scale("cafeteria.png", 1920, 1080)
image bg_comptoire = im.Scale("comptoire.png", 1920, 1080)
image bg_hall = im.Scale("hall.png", 1920, 1080)
image bg_cuisine = im.Scale("cuisine.png", 1920, 1080)
image bg_stairs = im.Scale("escaliers.png", 1920, 1080)
image bg_bureau = im.Scale("bureau.png", 1920, 1080)

define audio.glitch_sfx = "audio/glitch.wav" 

init python:
    renpy.music.register_channel("background", "bgs", loop=True)
    renpy.music.register_channel("background_sppl", "bgs", loop=True)

label splashscreen:
    scene black
    pause 1.0

    show text "Vous êtes sur le point de vivre le quotidien\nd'une personne souffrant de troubles obsessionnels compulsifs." with dissolve
    pause 3.0
    
    hide text with dissolve
    show text "Voici son quotidien." with dissolve
    pause 1.0

    play sound glitch_sfx
    show text "Voici {glitch}son{/glitch} quotidien."
    pause 0.1
    show text "Voici {glitch}votre{/glitch} quotidien."
    pause 0.1

    show text "Voici votre quotidien."
    pause 0.5
    hide text with dissolve

    jump start

label start:
    play background "audio/classroom_sound.mp3" fadein 1.0 volume 0.45

    $ regarde_telephone = False
    $ a_ranger_feuille = False
    $ a_ranger_stylo = False
    $ avant_exercice_2 = True
    $ premier_lavage_final_fait = False

    scene bg_classroom with dissolve

    "Professeur" "Bien, ce sera tout pour le premier exercice."
    "Professeur" "Prenez dix minutes de pause. Nous enchaînerons ensuite avec l'exercice 2."

    menu:
        "Regarder son téléphone":
            jump telephone

        "Se laver les mains":
            jump sequence_lavage_classe

label telephone:
    $ regarde_telephone = True
    scene black with dissolve
    
    "{i}Vous faites défiler l'écran sans but précis.{/i}"
    "{i}Juste pour occuper vos doigts.{/i}"

    jump retour_classe

label sequence_lavage_classe:
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    scene black with dissolve
    "J’ai touché la table. Le cahier aussi. Ce n’est sûrement rien."
    "Mais je préfère aller me laver les mains.."

    call hand_wash_game("normal", required_changes=15) from _call_hand_wash_game
   
    
    scene black with dissolve

    "Je regarde mes mains. Il reste une sensation..."
    "Ce n'est pas encore tout à fait propre. Encore un peu."

    call hand_wash_game("faible", required_changes=10) from _call_hand_wash_game_1

    
    scene black with dissolve
    "Voilà. Ça devrait aller pour l'instant."
    
    
    jump retour_classe

label retour_classe: 
    stop background fadeout 0.75 
    play background "audio/travailler.mp3" fadein 0.75

    scene bg_classroom with dissolve

    if regarde_telephone:
        "Le cours reprend. Vous rangez le téléphone."
    else:
        "Vous retournez à votre place."
    
    if avant_exercice_2:
        "L'exercice 2 va débuter. Mais votre regard se bloque sur votre table."
        "Les feuilles sont de travers. Les stylos pointent dans la mauvaise direction."
        "C'est insupportable."
    else:
        if a_ranger_feuille and not a_ranger_stylo:
            "Vous vous rasseyez pour l'exercice 2."
            "Les feuilles sont droites, mais ces stylos... Ils sont en désordre. C'est le chaos."
            "Impossible de se concentrer tant qu'ils ne sont pas alignés."

        elif not a_ranger_feuille and a_ranger_stylo:
            "Vous vous rasseyez pour l'exercice 2."
            "Les stylos sont alignés. Mais les feuilles... Elles dépassent. Elles vont tomber."
            "Il faut les remettre d'équerre."

        else:
            "Tout est parfaitement aligné. Le calme est revenu sur votre bureau."
    window hide
    menu: 
        "Je dois absolument terminer cet exercice" if a_ranger_feuille or a_ranger_stylo:
            jump exercice_2_fini

        "Ranger les feuilles" if not a_ranger_feuille:
            $ a_ranger_feuille = True
            $ avant_exercice_2 = False
            jump ranger_feuille

        "Aligner les stylos" if not a_ranger_stylo:
            $ a_ranger_stylo = True
            $ avant_exercice_2 = False
            jump ranger_stylo 
    window show
            

label ranger_feuille:
    scene black with dissolve
    
    "Vous tapotez les feuilles contre la table. Une fois. Deux fois. Trois fois."
    "Elles sont parfaitement alignées."
    "Mais l'encre... elle n'était pas sèche. Vous avez une tache sur le pouce."
    
    jump sequence_lavage_feuille

label sequence_lavage_feuille:
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25
    
    
    scene black with dissolve
    "Sale. Contaminé."

    call hand_wash_game("faible", required_changes=10) from _call_hand_wash_game_2
    jump retour_classe

label ranger_stylo:
    scene black with dissolve

    play sound "audio/sons_stylo.mp3" volume 0.4
    pause 2.5

    "Vous alignez les stylos parallèlement au bord de la table. Au millimètre près."
    "Cependant, en les touchant... ils étaient tièdes. Moites."
    "Cette sensation grasse sur vos doigts."
    
    jump sequence_lavage_stylo

label sequence_lavage_stylo:
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    "Il faut enlever ce gras."
    call hand_wash_game("faible", required_changes=10) from _call_hand_wash_game_3
    jump retour_classe


label exercice_2_fini:
    scene black with dissolve
    scene bg_classroom with dissolve

    "L'exercice est terminé. Vous posez votre stylo avec précaution."
    pause 1.0

    "Ami" "Hey ! Ça va ?"
    "Ami" "On va se prendre un café à la cafétéria avant de rentrer, tu viens ?"

    menu:
        "Pourquoi pas !":
            jump cafet
        "Avec plaisir !":
            jump cafet


label cafet:
    stop background fadeout 0.5
    play background_sppl "audio/cafet_public.mp3" fadein 0.5 volume 0.35

    scene bg_cafet with dissolve
    "L'ambiance est bruyante. Trop de monde. Trop de contacts potentiels."

    $ cafe = False
    $ the = False  
    $ choco_chaud = False

    scene bg_comptoire with dissolve

    "Serveur" "Qu'est-ce que je vous sers ?"

    menu:
        "Un thé, s'il vous plaît.":
            $ the = True
            "Serveur" "Ça marche, un thé !"
        "Un café, s'il vous plaît.": 
            $ cafe = True
            "Serveur" "Ça marche, un café !"
        "Un chocolat chaud, s'il vous plaît.": 
            $ choco_chaud = True
            "Serveur" "Ça marche, un chocolat chaud !"

    pause 1.0
    "Serveur" "Et voici."
    
    scene bg_cafet with dissolve
    with vpunch 

    "Merde ! Une chaise... Je ne l'avais pas vue."
    "Vous trébuchez légèrement."

    if the:
        "Quelques gouttes de thé brûlant éclaboussent votre main."
    elif cafe:
        "Une tache sombre de café s'étale sur votre main."
    elif choco_chaud:
        "Le chocolat chaud, épais et sucré, coule sur vos doigts."

    "Vous frottez avec un mouchoir. Fort."
    pause 1.0

    "Ça colle. Ça pénètre les pores. Le mouchoir ne suffit pas."
    "Vous sentez le liquide sécher, devenir une croûte invisible."

    menu:
        "Se laver les mains, tout de suite":
            jump lavage_cafe


label lavage_cafe:
    scene black with dissolve
    stop background_sppl fadeout 0.5
    play background_sppl "audio/cafet_toilette.mp3" fadein 0.5 volume 0.14
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    "Si je ne le fais pas, je vais y penser tout le temps."

    call hand_wash_game("normal", required_changes=15) from _call_hand_wash_game_4
    
    "Est-ce que c'est parti ? Je sens encore le sucre."
    
    call hand_wash_game("miroir", required_changes=10) from _call_hand_wash_game_5

    jump retour_cafet

label retour_cafet:
    stop background_sppl fadeout 0.5
    stop background fadeout 0.5

    play background "audio/cafet_public.mp3" fadein 0.5 volume 0.35
    scene bg_cafet with dissolve

    "Vos mains sont sèches, irritées, mais propres."
    "Vos amis discutent. Vous hochez la tête sans écouter."
    "Il est temps de rentrer. Cet endroit est trop sale."

    jump dans_le_bus


label dans_le_bus:
    stop background fadeout 1.0
    play background "audio/bus.mp3" fadein 1.0 volume 0.4

    scene black with dissolve

    pause 5.0

    stop background fadeout 0.5
    play background "audio/sorti_bus.mp3" fadein 0.5
    "Vous descendez."
    
    jump maison_sequence

label maison_sequence:
    stop background fadeout 0.5
    play background "audio/en_dehors_maison.mp3" fadein 0.5 volume 5 
    scene bg_hall with dissolve
    
    "Enfin chez soi. Le sanctuaire."
    "Mais je ne peux rien toucher. Pas avant de m'être lavé les mains."

    stop background fadeout 0.5
    play background "audio/dans_maison.mp3" fadein 0.5 volume 5
    scene bg_cuisine with dissolve
    "Direction la cuisine. Immédiatement."



    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    "Premier lavage. Enlever le gros."
    call hand_wash_game("normal", required_changes=15) from _call_hand_wash_game_6
    stop background fadeout 0.5

    
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    "Deuxième lavage. Pour les microbes."
    call hand_wash_game("miroir", required_changes=15) from _call_hand_wash_game_7
    stop background fadeout 0.5

    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    "Troisième lavage. Pour être sûr."
    call hand_wash_game("miroir", required_changes=8) from _call_hand_wash_game_8
    stop background fadeout 0.5


    window hide
    stop background fadeout 1.0
    
    scene black with dissolve
    scene bg_stairs with dissolve
    play sound "audio/stairs.mp3"
    pause 2.0 
    scene black with dissolve
    stop sound fadeout 0.5

    jump chambre

label chambre:
    stop background fadeout 0.5
    play background "audio/dans_maison.mp3" fadein 0.5 volume 5

    scene bg_bureau with dissolve
    window show
    "Vous posez votre sac. Vous sortez la trousse, le cahier."
    "Tout est prêt pour demain."
    "Vous saisissez votre stylo pour commencer."

    "Concentre-toi."

    window hide
    call screen math_quiz_intro
    window show

    scene bg_bureau
    "Attends. {w=1} J'ai pourtant déjà fait ce qu'il fallait..."
    "Pourquoi est-ce que j'ai encore envie d'aller me laver les mains ?"

    jump chambre_lavage_extra

label chambre_lavage_extra:
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25
    
    "Juste un petit coup. Rapide."
    call hand_wash_game("miroir", required_changes=10) from _call_hand_wash_game_9
    
    jump retoure_lavage_extra

label retoure_lavage_extra:
    stop background fadeout 0.5
    play background "audio/dans_maison.mp3" fadein 0.5 volume 5
    # play background_sppl "audio/whisper.mp3" fadein 0.5 volume 0.75 loop

    scene bg_bureau with dissolve
    window show

    pause 2.0

    "Mais..."
    "Je viens de me laver les mains..."
    "Je n'arrive plus à me concentrer."
    "Je n'arrive plus à penser."
    "Je n'arrive plus à écrire."

    jump lavage_terminal_1

label lavage_terminal_1 :
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    call hand_wash_game("miroir", required_changes=10) from _call_hand_wash_game_10

    jump retour_lavage_terminal_1

label retour_lavage_terminal_1:
    stop background fadeout 0.5
    play background "audio/dans_maison.mp3" fadein 0.5 volume 5

    scene bg_bureau with dissolve
    window show

    pause 2.0

    "Non."
    "Je sais que je vais y retourner."
    "Juste pour que ça s'arrête."

    jump lavage_terminal_2

label lavage_terminal_2 :
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    call hand_wash_game("miroir", required_changes=10, red=True) from _call_hand_wash_game_11

    jump retour_lavage_terminal_2

label retour_lavage_terminal_2:
    stop background fadeout 0.5
    play background "audio/dans_maison.mp3" fadein 0.5 volume 5

    scene bg_bureau with dissolve
    window show


    "Encore une fois."
    "Encore."
    "Une dernière fois, après je m'arrête."


    jump lavage_terminal_3

label lavage_terminal_3 :
    stop background fadeout 0.5
    play background "audio/toilette.mp3" fadein 0.5 volume 1.25

    call hand_wash_game("miroir", required_changes=10, red=True) from _call_hand_wash_game_12

    jump tentative_devoir

label tentative_devoir:
    stop background fadeout 0.5
    stop background_sppl fadeout 0.5
    play background "audio/dans_maison.mp3" fadein 0.5 volume 5

    pause 2.0

    "Ok."
    "Respire."
    "Tout va bien."


    "Essayons de faire les devoirs..."

    jump commencer_devoir




label commencer_devoir:
    scene bg_bureau with dissolve
    "Allez. Concentre-toi. C'est juste des maths."
    "Mais je sens mes mains... elles picotent."

    window hide
    call screen math_quiz
    window show

    stop background fadeout 0.2

    "NON. NON. NON."
    "Ce bouton... il était contaminé. Tout est contaminé."
    "Le stylo. La feuille. Le bureau. Moi."
    "Je ne peux plus m'arrêter."

    jump dernier_lavage

label dernier_lavage:
    scene black
    call hand_wash_game("vide", red=True) from _call_hand_wash_game_13
    
    $ renpy.run(OpenURL("https://again-and-again.alixz.ovh/message.html"))
    $ renpy.quit()