define my_font = "comic.otf"

init python:
    import random

    questions = [
        {"a":2, "b":5, "answers":[2,5,7,8], "correct":2, "pos":(0.36,0.195)},
        {"a":10, "b":7, "answers":[17,16,15,18], "correct":0, "pos":(0.39,0.38)},
        {"a":3, "b":4, "answers":[5,7,6,8], "correct":1, "pos":(0.355,0.52)},
        {"a":9, "b":6, "answers":[14,15,16,13], "correct":1, "pos":(0.40,0.69)}
    ]

    questions_intro = [
        {"a":8, "b":4, "answers":[11,12,13,10], "correct":1, "pos":(0.40,0.195)},
        {"a":6, "b":7, "answers":[13,14,12,15], "correct":0, "pos":(0.40,0.38)}, 
        {"a":5, "b":9, "answers":[14,13,16,12], "correct":0, "pos":(0.40,0.52)},
        {"a":12, "b":3, "answers":[14,15,16,13], "correct":1, "pos":(0.40,0.69)}
    ]

    button_positions = [
        (0.9, .1, 1.0),
        (0.3, 0.4, 0.9),
        (0.8, 0.77, 1.7)
    ]

default feedback_indices_intro = {}
default feedback_indices = {}
default popped_buttons = []
default is_spawning_active = False

transform scale_button(size=1.0):
    zoom size

init python:
    style.answer_text = Style(style.default)
    style.answer_text.font = my_font
    style.answer_text.size = 60
    style.answer_text.color = "#444444"
    style.answer_text.hover_color = "#000000"
    style.answer_text.insensitive_color = "#44444480"
    style.correct_answer_text = Style(style.answer_text)
    style.correct_answer_text.color = "#00aa00"
    style.correct_answer_text.hover_color = "#00aa00"
    style.wrong_answer_text = Style(style.answer_text)
    style.wrong_answer_text.color = "#aa0000"
    style.wrong_answer_text.hover_color = "#aa0000"
    style.pop_button = Style(style.choice_button)
    style.pop_button_text = Style(style.choice_text)
    style.pop_button_text.xalign = 0.5

init python:
    def spawn_random_button():
        random_button = (random.uniform(0.0, 1.0), random.uniform(0.0, 1.0), random.uniform(0.3, 2.0))
        store.popped_buttons.append(random_button)
        renpy.restart_interaction()

    def select_answer_intro(question_index, answer_index):
        if question_index == 2:
            renpy.end_interaction(True)
            return

        if question_index not in store.feedback_indices_intro:
            store.feedback_indices_intro[question_index] = answer_index
            renpy.restart_interaction()


    def select_answer(question_index, answer_index):
        if question_index not in store.feedback_indices:
            store.feedback_indices[question_index] = answer_index

            if question_index < len(button_positions):
                button_to_add = button_positions[question_index]
                if button_to_add not in store.popped_buttons:
                    store.popped_buttons.append(button_to_add)

            if not store.is_spawning_active:
                store.is_spawning_active = True
            
            renpy.restart_interaction()

    def finish_minigame():
        store.is_spawning_active = False

screen math_quiz():
    modal True
    on "show":
        action [
            SetField(store, "feedback_indices", {}),
            SetField(store, "popped_buttons", []),
            SetField(store, "is_spawning_active", False)
        ]

    if is_spawning_active:
        timer 1.8 repeat True action Function(spawn_random_button)

    add "images/sheet.png" fit "cover"

    python:
        active_question_index = -1
        for i in range(len(questions)):
            if i not in store.feedback_indices:
                active_question_index = i
                break

    for qi, q in enumerate(questions):
        vbox:
            xpos q["pos"][0]
            ypos q["pos"][1]
            xanchor 0.5
            spacing -22
            text f"{q['a']} + {q['b']} = ?" font my_font size 60 color "#000" xalign 0.0
            hbox:
                xalign 0.0
                spacing 40
                for ai, ans in enumerate(q["answers"]):
                    $ is_sensitive = (qi == active_question_index)
                    $ current_text_style = style.answer_text
                    if qi in feedback_indices:
                        if ai == q["correct"]:
                            $ current_text_style = style.correct_answer_text
                        elif ai == feedback_indices[qi]:
                            $ current_text_style = style.wrong_answer_text
                    textbutton str(ans):
                        style_prefix "answer"
                        text_style current_text_style
                        sensitive is_sensitive
                        action Function(select_answer, question_index=qi, answer_index=ai)

    for x, y, size in popped_buttons:
        textbutton "Se laver les mains" style "pop_button":
            xpos x
            ypos y
            xanchor 0.5
            yanchor 0.5
            action [
                Function(finish_minigame),
                Return(True)
            ]
            at scale_button(size=size)

screen math_quiz_intro():
    modal True
    
    on "show":
        action SetField(store, "feedback_indices_intro", {})

    add "images/sheet.png" fit "cover"

    python:
        active_question_index = -1
        for i in range(len(questions_intro)):
            if i not in store.feedback_indices_intro:
                active_question_index = i
                break

    for qi, q in enumerate(questions_intro):
        vbox:
            xpos q["pos"][0]
            ypos q["pos"][1]
            xanchor 0.5
            spacing -22
            text f"{q['a']} + {q['b']} = ?" font my_font size 60 color "#000" xalign 0.0
            hbox:
                xalign 0.0
                spacing 40
                for ai, ans in enumerate(q["answers"]):
                    $ is_sensitive = (qi == active_question_index)
                    $ current_text_style = style.answer_text
                    
                    if qi in feedback_indices_intro:
                        if ai == q["correct"]:
                            $ current_text_style = style.correct_answer_text
                        elif ai == feedback_indices_intro[qi]:
                            $ current_text_style = style.wrong_answer_text
                    
                    textbutton str(ans):
                        style_prefix "answer"
                        text_style current_text_style
                        sensitive is_sensitive
                        action Function(select_answer_intro, question_index=qi, answer_index=ai)