init python:
    import random
    import pygame
    
    HANDWASH_LEVELS = {
        "normal": [ 
            (1100, 750), 
            (1170, 790, {"pos": (1135, 55), "scale": 0.6, "alpha": 0.5}), 
            (700, 800, {"pos": (747, -20), "scale": 0.6, "alpha": 0.5}), 
            (1150, 900, {"pos": (1115, -10), "scale": 0.6, "alpha": 0.5}) 
        ],
        "faible": [ 
            (1150, 800, {"pos": (1135, 45), "scale": 0.6, "alpha": 0.33}), 
            (670, 900, {"pos": (747, -6), "scale": 0.6, "alpha": 0.33}), 
            (700, 700) 
        ],
        "miroir": [ 
            (1100, 750), 
            (1170, 790), 
            (700, 800), 
            (1150, 900) 
        ],
        "vide": [] 
    }

    class HandWash(renpy.Displayable):
        def __init__(self, level_id="normal", required_changes=10, gel=False, red=False, **kwargs):
            super().__init__(**kwargs)

            if red:
                self.bg_filename = "handwash_red.png"
            else:
                self.bg_filename = "handwash.png"

            self.positions = HANDWASH_LEVELS.get(level_id, [])
            self.count = len(self.positions)
            self.required = required_changes
            self.gel = gel
            self.cursed = (self.count == 0)
            
            self.ink_files = ["images/ink1.png", "images/ink2.png"]
            self.stains = []
            self.per_stain_changes = [0] * self.count
            self.cleaned = 0
            self.holding = False
            self.last_pos = None
            self.sign_x = 0
            self.sign_y = 0
            self.randomkey = random.random()
            self.glitch_active = False 

            self._setup_stains()

        def _setup_stains(self):
            for i, entry in enumerate(self.positions):
                x, y = entry[0], entry[1]
                mirror_data = entry[2] if len(entry) > 2 else None

                file_idx = i % len(self.ink_files)
                chosen_file = self.ink_files[file_idx]

                size = random.randint(80, 120)
                img = im.Scale(chosen_file, size, size)

                mirror_entry = None
                if mirror_data:
                    mx, my = mirror_data["pos"]
                    m_scale = mirror_data.get("scale", 1.0)
                    m_alpha = mirror_data.get("alpha", 1.0)

                    msize = int(size * m_scale)
                    
                    m_img = im.Scale(chosen_file, msize, msize)
                    m_img = im.Alpha(m_img, m_alpha)
                    
                    mirror_entry = (mx, my, msize, msize, m_img)

                self.stains.append([x, y, size, size, False, img, mirror_entry])

        def _stain_at(self, x, y):
            for i, (sx, sy, sw, sh, cleaned, img, mirror) in enumerate(self.stains):
                if not cleaned and sx <= x <= sx + sw and sy <= y <= sy + sh:
                    return i
            return None

        def _draw_counter(self, r, st, at):
            if self.cursed:
                txt_str = "0/" + "9" * 40
            else:
                txt_str = f"{self.cleaned}/{self.count}"

            txt = renpy.text.text.Text(txt_str, size=40, color="#ffffff")
            tr = renpy.render(txt, 1000, 80, st, at)
            r.blit(tr, (1920 - 220, 20))

        def _draw_gel_banner(self, r, st, at):
            if not self.gel: return
            bg = Solid("#222c", xysize=(420, 60))
            bgr = renpy.render(bg, 420, 60, st, at)
            r.blit(bgr, (20, 20))

            txt = renpy.text.text.Text("Gel hydroalcoolique", size=30, color="#ffffff")
            tr = renpy.render(txt, 420, 60, st, at)
            r.blit(tr, (35, 28))
        
        def _blit_wrapped(self, target, source, x, y, width):
            target.blit(source, (x, y))
            if x > 0:
                target.blit(source, (x - width, y))
            elif x < 0:
                target.blit(source, (x + width, y))

        def _apply_full_screen_glitch(self, source_render, st):
            w, h = source_render.get_size()
            h = int(h)
            res = renpy.Render(w, h)
            
            randomobj = renpy.random.Random(self.randomkey + int(st * 20))
            chroma = renpy.display.render.models
            
            nb_bands = randomobj.randint(2, 4)
            step = h // nb_bands
            
            bands_y = []
            for i in range(nb_bands):
                bands_y.append(i * step)
            bands_y.append(h)

            for i in range(nb_bands):
                y1 = bands_y[i]
                y2 = bands_y[i+1]
                band_height = y2 - y1
                
                band = source_render.subsurface((0, y1, w, band_height))
                
                offset_x = randomobj.randint(-600, 600)
                intensity = randomobj.uniform(0.8, 1.3)

                if chroma:
                    for color_mask, ponder in (
                        ((False, False, True, True), 1.4 * intensity),
                        ((False, True, False, True), 1.0 * intensity),
                        ((True, False, False, True), 0.6 * intensity),
                    ):
                        chroma_band = band.subsurface((0, 0, w, band_height))
                        chroma_band.add_property("gl_color_mask", color_mask)
                        
                        final_x = round(offset_x * ponder)
                        self._blit_wrapped(res, chroma_band, final_x, y1, w)
                else:
                    self._blit_wrapped(res, band, offset_x, y1, w)
            
            return res

        def render(self, width, height, st, at):
            scene_r = renpy.Render(1920, 1080)

            bg = im.Scale(self.bg_filename, 1920, 1080)
            bgr = renpy.render(bg, 1920, 1080, st, at)
            scene_r.blit(bgr, (0, 0))

            for (x, y, w, h, cleaned, img, mirror) in self.stains:
                if not cleaned:
                    if mirror:
                        mx, my, mw, mh, mimg = mirror
                        mr = renpy.render(mimg, mw, mh, st, at)
                        scene_r.blit(mr, (mx, my))
                    ir = renpy.render(img, w, h, st, at)
                    scene_r.blit(ir, (x, y))

            self._draw_counter(scene_r, st, at)
            self._draw_gel_banner(scene_r, st, at)

            mx, my = renpy.get_mouse_pos()
            sponge = im.Scale("eponge.png", 96, 96)
            sr = renpy.render(sponge, 96, 96, st, at)
            scene_r.blit(sr, (mx - 48, my - 48))

            if self.cursed:
                is_glitching = False
                
                if 3.0 <= st < 3.05:
                    is_glitching = True
                elif 6.0 <= st < 6.1:
                    is_glitching = True
                elif st >= 6.1:
                    renpy.end_interaction(1)

                if is_glitching:
                    if not self.glitch_active:
                        renpy.sound.play("glitch.wav")
                        self.glitch_active = True

                    final_r = self._apply_full_screen_glitch(scene_r, st)
                    renpy.redraw(self, 0.05) 
                    return final_r
                else:
                    self.glitch_active = False
                    renpy.redraw(self, 0)
                    return scene_r

            return scene_r

        def event(self, ev, x, y, st):
            if self.cursed:
                return None

            if ev.type == pygame.MOUSEMOTION:
                if self.holding and self.last_pos is not None:
                    dx = x - self.last_pos[0]
                    dy = y - self.last_pos[1]

                    sx = 1 if dx > 0 else (-1 if dx < 0 else 0)
                    sy = 1 if dy > 0 else (-1 if dy < 0 else 0)

                    idx = self._stain_at(x, y)
                    if idx is not None:
                        changed = False
                        if sx != 0 and sx != self.sign_x:
                            self.sign_x = sx
                            changed = True
                        if sy != 0 and sy != self.sign_y:
                            self.sign_y = sy
                            changed = True

                        if changed:
                            self.per_stain_changes[idx] += 1
                            if self.per_stain_changes[idx] >= self.required and not self.stains[idx][4]:
                                self.stains[idx][4] = True
                                self.cleaned += 1
                                self.sign_x = 0
                                self.sign_y = 0

                                if self.cleaned >= self.count:
                                    renpy.sound.stop()
                                    renpy.end_interaction(1)

                self.last_pos = (x, y)

            elif ev.type == pygame.MOUSEBUTTONDOWN and ev.button == 1:
                renpy.sound.play("sponge.mp3", loop=True, relative_volume=2.5)
                self.holding = True
                self.last_pos = (x, y)
                self.sign_x = 0
                self.sign_y = 0

            elif ev.type == pygame.MOUSEBUTTONUP and ev.button == 1:
                renpy.sound.stop()
                self.holding = False
                self.sign_x = 0
                self.sign_y = 0

            renpy.redraw(self, 0)
            return None

screen hand_wash(level_id="normal", required_changes=10, gel=False, red=False):
    modal True
    zorder 100

    add HandWash(level_id, required_changes, gel, red)

    text "Maintiens le clic gauche et frotte les taches." xpos 20 ypos 1040 size 22 color "#ffffffaa"

label hand_wash_game(level_id="normal", required_changes=10, gel=False, red=False):
    window hide
    call screen hand_wash(level_id=level_id, required_changes=required_changes, gel=gel, red=red)
    window show
    return