init python:
    import random

    class Glitch(renpy.Displayable, str):
        def __init__(self, text, **kwargs):
            super(Glitch, self).__init__(**kwargs)
            if isinstance(text, (str, unicode)):
                self.child = Text(text)
            else:
                self.child = text

            self.randomkey = random.random()

        def render(self, width, height, st, at):
            child_render = renpy.render(self.child, width, height, st, at)
            cwidth, cheight = child_render.get_size()
            cheight = int(cheight)

            if cheight < 30:
                return child_render

            render = renpy.Render(cwidth, cheight)
            randomobj = renpy.random.Random(self.randomkey + int(st * 1000))
            chroma = renpy.display.render.models
            step = cheight // 3
            bands = [0, step, step * 2, cheight]

            for i in range(3):
                y1, y2 = bands[i], bands[i + 1]
                band_height = y2 - y1
                band = child_render.subsurface((0, y1, cwidth, band_height))
                offset_x = randomobj.randint(-50, 50)
                intensity = randomobj.uniform(0.8, 1.3)

                if chroma:
                    for color_mask, ponder in (
                        ((False, False, True, True), 1.4 * intensity),
                        ((False, True, False, True), 1.0 * intensity),
                        ((True, False, False, True), 0.6 * intensity),
                    ):
                        chroma_band = band.subsurface((0, 0, cwidth, band_height))
                        chroma_band.add_property("gl_color_mask", color_mask)
                        render.blit(chroma_band, (round(offset_x * ponder), y1))
                else:
                    render.blit(band, (offset_x, y1))

            renpy.redraw(self, 0.1)
            return render

        def __new__(cls, text, *args, **kwargs):
            if isinstance(text, (str, unicode)):
                return str.__new__(cls, text)
            return str.__new__(cls, "")

    def glitch_tag(tag, argument, contents):
        new_list = []
        for kind, text in contents:
            if kind == renpy.TEXT_TEXT:
                disp = Glitch(text)
                new_list.append((renpy.TEXT_DISPLAYABLE, disp))
            else:
                new_list.append((kind, text))
        return new_list

    config.custom_text_tags["glitch"] = glitch_tag
